/*
 *  GridCell.h
 *  chemistryEcosys
 *
 *  Created by Alan Dorin on 12/04/07.
 *  Copyright 2007 __MyCompanyName__. All rights reserved.
 *
 */

#ifndef _GRIDCELL_H_
#define _GRIDCELL_H_

#include "SimpleVector.h"
class Ship;
class Gold;

// A grid cell is a place in space where a ship can be. And so can a pot of gold.
class GridCell
{
	private:
        SimpleVector		position;		// actual vector position of cell centre
		SimpleVector		dimensions;		// dimensions of this cell
        Ship*		ship;			// pointer to the Ship (if there is one) at this location
		Gold*		gold;			// pointer to a gold (if there is some) at this location
		bool		cannonBallPassedThrough;	// flag true/false if a cannonball travelled through this cell
		bool		rock;			// flag true/false if this cell is occupied by a rock
		bool		wreck;			// flag true/false if this cell is occupied by a shipwreck
		
    public:
	
		GridCell(void);
        GridCell(const GridCell& src);
        ~GridCell(void);
        
        void setShipPtr(Ship* shipPtr);
        void setGoldPtr(Gold* goldPtr);
		
		void clearShip(void);
		void clearGold(void);
		void clearCannonBallPassedThrough(void);
		
        int getShipId(void);
		int getGoldIndex(void);
		
        bool isOccupiedByShip(void);
		bool isOccupiedByGold(void);
		bool isOccupiedByRock(void);
		bool isOccupiedByWreck(void);
		
		void setCannonBallPassedThrough(bool ballFlag);
		bool getCannonBallPassedThrough(void);
		
		void setRock(void);
		void clearRock(void);
		
		void setWreck(void);
		void clearWreck(void);
		
        void setPosition(const SimpleVector& newPos);
        SimpleVector getPosition(void);
		void setDimensions(const SimpleVector& newDim);
        SimpleVector getDimensions(void);
		
        void displayShip(void);
		void displayGold(void);
		void displayCannonPath(void);
		void displayRock(void);
		void displayWreck(void);
		
		void displayCellIndex(long number);
		
		GridCell& operator= (const GridCell& rhs);
};

#endif
